<?php

class arpreach {

	var $_unsubscribe = FALSE;

	function arpreach() // constructor
	{
	}

	//======== USER REGISTRATION ========
	function register($userId, $productId, $params)
	{
		$action = $this->_unsubscribe? 'unregister': 'register';
		logToFile("arpreach.class.php: $action(): user_id = $userId", LOG_INFO_DAP);
		if (FALSE === extension_loaded('curl')) {
			logToFile("arpreach.class.php: The curl extension must be loaded for using this class !", LOG_INFO_DAP);
			return "cURL is not available";
		}

		$form_url = $this->validate_url(trim($params));
		if (FALSE === $form_url) {
			logToFile("arpreach.class.php: $action(): INVALID form url = $params", LOG_INFO_DAP);
			return "INVALID form url";
		}
		logToFile("arpreach.class.php: $action(): form = $form_url", LOG_INFO_DAP);
		$postfields = array();

		try {
			$dapuser   = Dap_User::loadUserById($userId);
			logToFile("arpreach.class.php: $action(): Dap_User::loadUserById() was ok", LOG_INFO_DAP);
			$form_data = array(
				'email_address'       => trim($dapuser->getEmail()),
				'first_name'          => trim($dapuser->getFirst_name()),
				'last_name'           => trim($dapuser->getLast_name()),

				'phone_number_1'      => trim($dapuser->getPhone()),
				'fax_number_1'        => trim($dapuser->getFax()),
				'company'             => trim($dapuser->getCompany()),
				'title'               => trim($dapuser->getTitle()),

				'address_1'           => trim($dapuser->getAddress1()),
				'address_2'           => trim($dapuser->getAddress2()),
				'city'                => trim($dapuser->getCity()),
				'state'               => trim($dapuser->getState()),
				'postal_code'         => trim($dapuser->getZip()),
				'country'             => trim($dapuser->getCountry())

			);
			logToFile("arpreach.class.php: $action(): get User details", LOG_INFO_DAP);
		} catch (PDOException $e) {
			logToFile("arpreach.class.php: $action(): user details can't be retrieved ".$e->getMessage(), LOG_INFO_DAP);
			return "user details can't be retrieved";
		} catch (Exception $e) {
			logToFile("arpreach.class.php: $action(): user details can't be retrieved ".$e->getMessage(), LOG_INFO_DAP);
			return "user details can't be retrieved";
		}

		if ( $this->_unsubscribe ) {
			$form_data['unsubscribe'] = 1;
		}
	
		foreach ($form_data as $f => $v) {
			logToFile("arpreach.class.php: $action(): data: $f = $v", LOG_INFO_DAP);
			$postfields[] = $f.'='.$v;
		}
		
		$curl = curl_init($form_url);
		if ( $curl ) {
			curl_setopt($curl, CURLOPT_USERAGENT, 'DAP-ARP');
			curl_setopt($curl, CURLOPT_HEADER,         FALSE);
			curl_setopt($curl, CURLOPT_POST,           TRUE);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
			curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE);
			curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 30);
			curl_setopt($curl, CURLOPT_TIMEOUT,        30);
			curl_setopt($curl, CURLOPT_POSTFIELDS, implode('&',$postfields));
			curl_exec  ($curl);
			
			if( curl_errno($curl) > 0 ) {
				logToFile("arpreach.class.php: $action(): Unable to connect to $form_url Error: ".curl_error($curl), LOG_INFO_DAP);
				curl_close ($curl);
				return "Unable to connect to $form_url Error: ".curl_error($curl);
			}
			else {
				logToFile("arpreach.class.php: $action(): Response HTTP-CODE: ".curl_getinfo($curl, CURLINFO_HTTP_CODE), LOG_INFO_DAP);
				curl_close ($curl);
				return 0;
			}
		}
		else {
			logToFile("arpreach.class.php: $action(): CURL is not available", LOG_INFO_DAP);
			return "CURL is not available";
		}
		
	} // function register($userId, $productId, $params)


	function unregister($userId, $productId, $params)
	{
		$this->_unsubscribe = TRUE;
		$this->register($userId, $productId, $params);
	} // function unregister($userId, $productId, $params)

	function validate_url($url)
	{
		return preg_match('{(\b(https?://)?[A-Z0-9][A-Z0-9_-]*(\.[A-Z0-9][A-Z0-9_-]*)*\.((a[cdefgilmnoqrstuwxz]|aero|arpa)|(b[abdefghijmnorstvwyz]|biz)|(c[acdfghiklmnorsuvxyz]|cat|com|coop)|d[ejkmoz]|(e[ceghrstu]|edu)|f[ijkmor]|(g[abdefghilmnpqrstuwy]|gov)|h[kmnrtu]|(i[delmnoqrst]|info|int)|(j[emop]|jobs)|k[eghimnprwyz]|l[abcikrstuvy]|(m[acdghklmnopqrstuvwxyz]|me|mil|mobi|museum)|(n[acefgilopruz]|name|net)|(om|org)|(p[aefghklmnrstwy]|pro)|qa|r[eouw]|s[abcdeghijklmnortvyz]|(t[cdfghjklmnoprtvwz]|travel)|u[agkmsyz]|v[aceginu]|w[fs]|y[etu]|z[amw])(\.((a[cdefgilmnoqrstuwxz]|aero|arpa)|(b[abdefghijmnorstvwyz]|biz)|(c[acdfghiklmnorsuvxyz]|cat|com|coop)|d[ejkmoz]|(e[ceghrstu]|edu)|f[ijkmor]|(g[abdefghilmnpqrstuwy]|gov)|h[kmnrtu]|(i[delmnoqrst]|info|int)|(j[emop]|jobs)|k[eghimnprwyz]|l[abcikrstuvy]|(m[acdghklmnopqrstuvwxyz]|mil|mobi|museum)|(n[acefgilopruz]|name|net)|(om|org)|(p[aefghklmnrstwy]|pro)|qa|r[eouw]|s[abcdeghijklmnortvyz]|(t[cdfghjklmnoprtvwz]|travel)|u[agkmsyz]|v[aceginu]|w[fs]|y[etu]|z[amw]))?(/[A-Z0-9_\.%~-]+)*/?(\?[A-Z0-9_\.\?/^=;:&#\!@%\$\+~-]+)?\b)}sim', $url, $m)? (empty($m[2])? 'http://': '') . $m[1]: FALSE;
	} // function validate_url($url)

} // class arpreach
?>
