<?php

class Dap_MassActions {
   	var $id;
   	var $actionType;
   	var $actionKey;
   	var $payload;
   	var $status;
   	var $comments;
  	var $last_update_ts;
 
	function getId() {
		return $this->id;
	}
	function setId($o) {
		$this->id = $o;
	}
	
	function getActionType() {
		return $this->actionType;
	}
	function setActionType($o) {
		$this->actionType = $o;
	}
	
	function getActionKey() {
		return $this->actionKey;
	}
	function setActionKey($o) {
		$this->actionKey = $o;
	}
	
	function getPayload() {
		return $this->payload;
	}
	function setPayload($o) {
		$this->payload = $o;
	}

	function getStatus() {
		return $this->status;
	}
	function setStatus($o) {
		$this->status = $o;
	}
	
	function getComments() {
		return $this->comments;
	}
	function setComments($o) {
		$this->comments = $o;
	}
	
	function getLastUpdateTs() {
		return $this->last_update_ts;
	}
	function setLastUpdateTs($o) {
		$this->last_update_ts = $o;
	}
	
	
 	public function load() {
		//logToFile("in Dap_MassActions->load()",LOG_DEBUG_DAP);
		$dap_dbh = Dap_Connection::getConnection();

		$sql = "select * from dap_mass_actions
				order by id desc";
		$resourceArray = array();

		$stmt = $dap_dbh->prepare($sql);
		$stmt->execute();

		while ($obj = $stmt->fetch(PDO::FETCH_ASSOC)) {
			$resourceArray[] = $obj;
		}
		
		return $resourceArray;
	}
			
 	
	public static function deleteMassActionsData($status) {
		//logToFile("in Dap_MassActions->load()",LOG_DEBUG_DAP);
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "delete from dap_mass_actions where ";
			
			if($status == "E") {
				$sql .= " status = '$status' ";
			} else if($status == "C") {
				$sql .= " status = '$status' and DATE(last_update_ts) < \"".date("Y-m-"). (date("d")-1)."\"";
			} else if($status == "A") {
				$sql .= "1";
			}

			//logToFile("$sql",LOG_DEBUG_DAP);
			$stmt = $dap_dbh->prepare($sql);
			$stmt->execute();
			
			$stmt = null;
			$dap_dbh = null;
			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}

	public static function deleteJobFromJobQueue($id) {
		//logToFile("in Dap_MassActions->deleteJobFromJobQueue(), id: $id",LOG_DEBUG_DAP);
		try {
			$dap_dbh = Dap_Connection::getConnection();
			
			$sql = "delete from dap_mass_actions where id = :id";
			$stmt = $dap_dbh->prepare($sql);
			$stmt->bindParam(':id', $id, PDO::PARAM_INT);
			$stmt->execute();
    			
			$stmt = null;
			$dap_dbh = null;
			
			return;
		} catch (PDOException $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		} catch (Exception $e) {
			logToFile($e->getMessage(),LOG_FATAL_DAP);
			throw $e;
		}	
	}

}
?>
