<?php
	include_once ("dap-config.php");	
	
	/*
		Three possible use cases.
		1) New member, new product association
		2) Existing member, new product
		3) Existing member, old product (don't extend)
	*/

	//Core "User" data
	$first_name = isset($_REQUEST['first_name']) ? addslashes($_REQUEST['first_name']) : "";
	$last_name = isset($_REQUEST['last_name']) ? addslashes($_REQUEST['last_name']) : "";
	$user_name = isset($_REQUEST['user_name']) ? addslashes($_REQUEST['user_name']) : "";
	$email = isset($_REQUEST['email']) ? addslashes($_REQUEST['email']) : "";
	//$password = isset($_REQUEST['password']) ? addslashes($_REQUEST['password']) : "";
	$address1 = isset($_REQUEST['address1']) ? addslashes($_REQUEST['address1']) : "";
	$address2 = isset($_REQUEST['address2']) ? addslashes($_REQUEST['address2']) : "";
	$city = isset($_REQUEST['city']) ? addslashes($_REQUEST['city']) : "";
	$state = isset($_REQUEST['state']) ? addslashes($_REQUEST['state']) : "";
	$zip = isset($_REQUEST['zip']) ? addslashes($_REQUEST['zip']) : "";
	$country = isset($_REQUEST['country']) ? addslashes($_REQUEST['country']) : "";
	$phone = isset($_REQUEST['phone']) ? addslashes($_REQUEST['phone']) : "";
	$fax = isset($_REQUEST['fax']) ? addslashes($_REQUEST['fax']) : "";
	$company = isset($_REQUEST['company']) ? addslashes($_REQUEST['company']) : "";
	$title = isset($_REQUEST['title']) ? addslashes($_REQUEST['title']) : "";
	$paypal_email = isset($_REQUEST['paypal_email']) ? addslashes($_REQUEST['paypal_email']) : "";
	
	logToFile("signup_submit.php:  email=". $email, LOG_FATAL_DAP);
	
	$productId = isset($_REQUEST['productId']) ? addslashes($_REQUEST['productId']) : "";
						
	$ipaddress = getIpOfUser();
	$thirdParty = true;
	$redirect = isset($_REQUEST['redirect']) ? addslashes($_REQUEST['redirect']) : "";
	if($redirect == "") {
		$redirect = Dap_Config::get("LOGIN_URL");
		$thirdParty = false;
	}
	$redirURL = "";
	$msg = "SUCCESS! Thank you for signing up. Please check your email for further details.";
	$user = null;
	
	//Basic validation
	if( ($first_name == "") || 
		($email == "") || 
		($productId == "") || 
		strpos($_REQUEST['email'], "\r") || 
		strpos($_REQUEST['email'], "\n") || 
		( isset($_REQUEST['user_name']) && ($_REQUEST['user_name'] == "") )  
	) {
		logToFile("Location:error.php?msg=Sorry, all fields are mandatory. Please go 'back' and fill up the missing information.", LOG_FATAL_DAP);
	
		echo -1;
		return;
	}
	if( validateEmailFormat($email) === false ) {
	
		logToFile("Location:error.php?msg=Sorry, the email address you entered is invalid. Please go 'back' and enter a valid email address.", LOG_FATAL_DAP);
		echo -2;
		return;
	}
	
	
	try {
		
		$user = new Dap_User();
		$user->setFirst_name($first_name);
		$user->setLast_name($last_name);
		$user->setUser_name($user_name);
		$user->setEmail($email);
		//$user->setPassword($password);
		$user->setAddress1($address1);
		$user->setAddress2($address2);
		$user->setCity($city);
		$user->setState($state);
		$user->setZip($zip);
		$user->setCountry($country);
		$user->setPhone($phone);
		$user->setFax($fax);
		$user->setCompany($company);
		$user->setTitle($title);
		$user->setPaypal_email($paypal_email);
		
		$user = Dap_UsersProducts::directSignupSubmit($user, $coupon_code, $productId, $couponId);
	
		
		if(isset($user)) {
			$uid = $user->getId();
			$_SESSION['uid'] = $uid;
			$_SESSION['AFF_LINK'] = SITE_URL_DAP . "/dap/a/?a=".$uid;
			
				// check if custom field present
			foreach($_REQUEST as $key=>$value)
			{
				logToFile("signup_submit.php: key=" . $key . " value=" . $value, LOG_DEBUG_DAP);		
					
				if (strstr($key, "custom_")) {	
					if ($keyval = substr($key, 7)) {
							
						$customFld = Dap_CustomFields::loadCustomfieldsByName($keyval);
						logToFile("signup_submit.php: loadCustomfieldsByName(): keyval=" . $keyval, LOG_DEBUG_DAP);		
						
						if ($customFld) {
							$id = $customFld->getId();
							logToFile("signup_submit.php: customFld Id = " . $id, LOG_DEBUG_DAP);		
							
							$usercustom = new Dap_UserCustomFields();
							
							$usercustom->setUser_id($uid);
							$usercustom->setCustom_id($id);
							$usercustom->setCustom_value($value);
							
							$cf = Dap_UserCustomFields::loadUserCustomFieldsByCustomFieldId($id, $uid);
							if ($cf) {
								logToFile("signup_submit.php: call update() to update value=" . $value, LOG_DEBUG_DAP);
								$usercustom->update();
							}
							else {
								logToFile("signup_submit.php: call create() to add custom value=" . $nv[1], LOG_DEBUG_DAP);
								$usercustom->create();
							}
						}
					}
				}
			}
		}
		
		//Load full user and update other info if available
		//$user = Dap_User::loadUserById($uid);
		
	} catch (PDOException $e) {
		logToFile($e->getMessage(),LOG_FATAL_DAP);
		$msg = $e->getMessage();
	} catch (Exception $e) {
		logToFile($e->getMessage(),LOG_FATAL_DAP);
		$msg = $e->getMessage();
	}		
	
	//Redirect to 'redirect' (if available) or member home page
	if($thirdParty == true) {
		$redirURL = $redirect;
	} else {
		$redirURL =  $redirect . "?msg=" . $msg;
	}
	
	echo 1;
	return;
	
	
?>